#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Trippy Dynamic 3d GridMod01.fsh    by     brian124634  
//https://www.shadertoy.com/view/wfXXRM
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

const float PI = 3.14159265359;

vec3 palette(float t) {
    vec3 a = vec3(0.5, 0.5, 0.5);
    vec3 b = vec3(0.5, 0.5, 0.5);
    vec3 c = vec3(1.0, 1.0, 1.0);
    vec3 d = vec3(0.263, 0.416, 0.557);
    return a + b*cos(2.*PI*(c*t+d));
}

mat2 rot2D (float angle) {
    float s = sin(angle);
    float c = cos(angle);
    return mat2(c, -s, s, c);
}

float sdBox(vec3 p, vec3 b ) {
  vec3 q = abs(p) - b;
  return length(max(q,0.0)) + min(max(q.x,max(q.y,q.z)),0.0);
}


float sdCross(vec3 p, float thickness) {
    float dx = sdBox(p, vec3(0.25*(1.+cos(2.*iTime)), thickness/2., thickness/2.));
    float dy = sdBox(p, vec3(thickness/2., 0.25*(1.+cos(2.*iTime-2./3.*PI)), thickness/2.));
    float dz = sdBox(p, vec3(thickness/2., thickness/2., 0.25*(1.+cos(2.*iTime-4./3.*PI))));
    return min(dx, min(dy, dz));
}

float sdSphere (vec3 p, float r) {
    return length(p) - r;
}

float map (vec3 p) {
    vec3 p2 = p;
    p.z += iTime * 1.0;
    vec3 spherePos = vec3(0, 0, 0);
    vec3 q = p;
    q.xy = fract(q.xy) - .5;
    q.z = mod(q.z, 1.) - 0.5;
    float cruz = sdCross(q, 0.2);
    return cruz;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = (fragCoord * 2.0 - iResolution.xy) / iResolution.y;
    vec2 m = (iMouse.xy * 2.0 - iResolution.xy) / iResolution.y;
    //Initialization
    vec3 ro = vec3(0, 0, -2);         //ray origin
    vec3 rd = normalize(vec3(uv, 1)); //ray direction
    vec3 col = vec3(0);               //final pixel color
    float t = 0.; //total distance traveled
    
    //Ray Marching
    int i;
    for (i = 0; i < 80; i++) {
        vec3 p = ro + rd * t;   //position along the ray
        p.xy *= rot2D(iTime*0.2);
        p.xz *= rot2D(iTime*0.2);
        p.y *= 0.5*sin(t*0.1+iTime*0.25);
        p.z *= 0.5*cos(t*0.1+iTime*0.25);
        float d = map(p);       //current distance to the scene
        t += d;   //"march" the ray
        
        if (d < .001 || t > 100.) break;
    }
    
    col = palette(t * 0.1 + float(i)*0.002)/t*5.;
    
    fragColor = vec4(col, 1);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

